/*
 * Decompiled with CFR 0.152.
 */
package com.wx.roundimageview;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;

public class RoundDrawable
extends Drawable {
    private static final int BORDER_COLOR = 0;
    private static final int BORDER_WIDTH = 0;
    private final Paint mPaint;
    private final Paint mBorderPaint;
    private final RectF mRectF;
    private final RectF mBorderRectF;
    private int mBitmapWidth;
    private int mBitmapHeight;
    private final int mBorderWidth;
    private final boolean mIsCircle;

    public RoundDrawable(Bitmap bitmap) {
        this(bitmap, 0, 0, false);
    }

    public RoundDrawable(Bitmap bitmap, int borderColor, int borderWidth, boolean isCircle) {
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap cannot be null.");
        }
        this.mBitmapWidth = bitmap.getWidth();
        this.mBitmapHeight = bitmap.getHeight();
        this.mIsCircle = isCircle;
        this.mBorderWidth = borderWidth;
        this.mRectF = new RectF();
        this.mBorderRectF = new RectF();
        Bitmap bm = null;
        if (this.mIsCircle) {
            bm = this.getSquareBitmap(bitmap);
        }
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setFilterBitmap(true);
        BitmapShader shader = new BitmapShader(bm == null ? bitmap : bm, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mPaint.setShader((Shader)shader);
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setDither(true);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setColor(borderColor);
        this.mBorderPaint.setStrokeWidth((float)borderWidth);
    }

    private Bitmap getSquareBitmap(Bitmap bitmap) {
        Bitmap bm;
        if (this.mBitmapWidth > this.mBitmapHeight) {
            bm = Bitmap.createBitmap((Bitmap)bitmap, (int)((this.mBitmapWidth - this.mBitmapHeight) / 2), (int)0, (int)this.mBitmapHeight, (int)this.mBitmapHeight);
            this.mBitmapWidth = this.mBitmapHeight;
        } else if (this.mBitmapWidth < this.mBitmapHeight) {
            bm = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)((this.mBitmapHeight - this.mBitmapWidth) / 2), (int)this.mBitmapWidth, (int)this.mBitmapWidth);
            this.mBitmapHeight = this.mBitmapWidth;
        } else {
            bm = bitmap;
        }
        return bm;
    }

    public void draw(Canvas canvas) {
        if (this.mIsCircle) {
            canvas.drawCircle(this.mRectF.centerX(), this.mRectF.centerY(), this.mRectF.centerX(), this.mPaint);
            canvas.drawCircle(this.mBorderRectF.centerX(), this.mBorderRectF.centerY(), this.mBorderRectF.centerX() - (float)this.mBorderWidth / 2.0f, this.mBorderPaint);
        } else {
            canvas.drawOval(this.mRectF, this.mPaint);
            canvas.drawOval(this.mBorderRectF, this.mBorderPaint);
        }
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mRectF.set(bounds);
        bounds.inset(this.mBorderWidth / 2, this.mBorderWidth / 2);
        this.mBorderRectF.set(bounds);
    }

    public void setAlpha(int alpha) {
        if (this.mPaint.getAlpha() != alpha) {
            this.mPaint.setAlpha(alpha);
            this.invalidateSelf();
        }
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public int getIntrinsicWidth() {
        return this.mBitmapWidth;
    }

    public int getIntrinsicHeight() {
        return this.mBitmapHeight;
    }

    public void setAntiAlias(boolean aa) {
        this.mPaint.setAntiAlias(aa);
        this.invalidateSelf();
    }

    public void setFilterBitmap(boolean filter) {
        this.mPaint.setFilterBitmap(filter);
        this.invalidateSelf();
    }

    public void setDither(boolean dither) {
        this.mPaint.setDither(dither);
        this.invalidateSelf();
    }
}

